# Début programme de démonstration des entrées analogique (Console)
# Ce programme mesure et affiche A0 dans la console Python.

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
brocheA0 = plugUno.get_pin('a:0:i')
# -> a  : signifie mode analogique
# -> 0  : numéro de la broche (0/1/2/3/4)
# -> i  : mode entré (est seule mode offert part Plug'Uno)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno.
plugUno.samplingOn()


################################
# Utilisation
################################
# lecture du niveau analogique de la broche :
# brocheA0.read()
# -> retourne un nombre flottant entre 0~1
# -> la valeur retourne est relative a la tension d'alimentation de Plug'Uno
# -> Admeton une tension d'alimentation de 5.0V -> tension = brocheA0.read()* 5 

# Boucle de lecture a la demande
while True :
    if input(
            "\n"
            "Appuyer sur \"ENTRER\" pour effectuer une mesure."
            "\n"
            "Saisir \"stop\" pour mettre fin a l'execution du programme."
            "\n"
    ) == "stop" :
        # Fermer la connexion à Plug'Uno avant de quitter.
        plugUno.exit()
        # Termine l'éxecution du programme Python.
        exit()

    print(
        "Valeur brute : ",
        brocheA0.read(),"/1 "
        "(soit ",
        "{:.2f}".format( brocheA0.read() * 5.0 ),    
        " V pour Vcc=5.0V)"
    )
        


# Fin programme de démonstration des entrées analogique (Console)
